// Copyright (c) 2025 The Chromium Embedded Framework Authors. All rights
// reserved. Use of this source code is governed by a BSD-style license that
// can be found in the LICENSE file.
//
// ---------------------------------------------------------------------------
//
// This file was generated by the CEF translator tool. If making changes by
// hand only do so within the body of existing method and function
// implementations. See the translator.README.txt file in the tools directory
// for more information.
//
// $hash=da2a74576bbc2ef5cd90672e9105546216408689$
//

#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_child_ctocpp.h"

#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_child_child_ctocpp.h"
#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_child_child_v1_ctocpp.h"
#include "libcef_dll/ctocpp/test/api_version_test_ref_ptr_library_child_child_v2_ctocpp.h"
#include "libcef_dll/shutdown_checker.h"

// STATIC METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
CefRefPtr<
    CefApiVersionTestRefPtrLibraryChild> CefApiVersionTestRefPtrLibraryChild::
    Create() {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval = cef_api_version_test_ref_ptr_library_child_create();

  // Return type: refptr_same
  return CefApiVersionTestRefPtrLibraryChildCToCpp_Wrap(_retval);
}

#if CEF_API_ADDED(13301)
NO_SANITIZE("cfi-icall")
CefRefPtr<
    CefApiVersionTestRefPtrLibraryChild> CefApiVersionTestRefPtrLibraryChild::
    Create(int value, int other_value) {
  shutdown_checker::AssertNotShutdown();

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  auto* _retval =
      cef_api_version_test_ref_ptr_library_child_create_with_default(
          value, other_value);

  // Return type: refptr_same
  return CefApiVersionTestRefPtrLibraryChildCToCpp_Wrap(_retval);
}
#endif  // CEF_API_ADDED(13301)

// VIRTUAL METHODS - Body may be edited by hand.

NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetOtherValue() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->get_other_value) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_other_value(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetOtherValue(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct = GetStruct();
  if (!_struct->set_other_value) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_other_value(_struct, value);
}

NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetValueLegacy() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->get_value_legacy) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_value_legacy(_struct);

  // Return type: simple
  return _retval;
}

NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetValueLegacy(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->set_value_legacy) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_value_legacy(_struct, value);
}

#if CEF_API_ADDED(CEF_EXPERIMENTAL)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetValueExp() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->get_value_exp) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_value_exp(_struct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_ADDED(CEF_EXPERIMENTAL)

#if CEF_API_ADDED(CEF_EXPERIMENTAL)
NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetValueExp(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->set_value_exp) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_value_exp(_struct, value);
}
#endif  // CEF_API_ADDED(CEF_EXPERIMENTAL)

#if CEF_API_REMOVED(13301)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetValue() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->get_value) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_value(_struct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_REMOVED(13301)

#if CEF_API_REMOVED(13301)
NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetValue(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->set_value) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_value(_struct, value);
}
#endif  // CEF_API_REMOVED(13301)

#if CEF_API_RANGE(13301, 13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetValueV1() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->get_value_v1) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_value_v1(_struct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_RANGE(13301, 13302)

#if CEF_API_RANGE(13301, 13302)
NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetValueV1(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->set_value_v1) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_value_v1(_struct, value);
}
#endif  // CEF_API_RANGE(13301, 13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
int CefApiVersionTestRefPtrLibraryChildCToCpp::GetValueV2() {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->get_value_v2) {
    return 0;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  int _retval = _struct->get_value_v2(_struct);

  // Return type: simple
  return _retval;
}
#endif  // CEF_API_ADDED(13302)

#if CEF_API_ADDED(13302)
NO_SANITIZE("cfi-icall")
void CefApiVersionTestRefPtrLibraryChildCToCpp::SetValueV2(int value) {
  shutdown_checker::AssertNotShutdown();

  auto* _struct =
      reinterpret_cast<cef_api_version_test_ref_ptr_library_t*>(GetStruct());
  if (!_struct->set_value_v2) {
    return;
  }

  // AUTO-GENERATED CONTENT - DELETE THIS COMMENT BEFORE MODIFYING

  // Execute
  _struct->set_value_v2(_struct, value);
}
#endif  // CEF_API_ADDED(13302)

// CONSTRUCTOR - Do not edit by hand.

CefApiVersionTestRefPtrLibraryChildCToCpp::
    CefApiVersionTestRefPtrLibraryChildCToCpp() {}

// DESTRUCTOR - Do not edit by hand.

CefApiVersionTestRefPtrLibraryChildCToCpp::
    ~CefApiVersionTestRefPtrLibraryChildCToCpp() {
  shutdown_checker::AssertNotShutdown();
}

template <>
cef_api_version_test_ref_ptr_library_child_t*
CefCToCppRefCounted<CefApiVersionTestRefPtrLibraryChildCToCpp,
                    CefApiVersionTestRefPtrLibraryChild,
                    cef_api_version_test_ref_ptr_library_child_t>::
    UnwrapDerived(CefWrapperType type, CefApiVersionTestRefPtrLibraryChild* c) {
#if CEF_API_REMOVED(13301)
  if (type == WT_API_VERSION_TEST_REF_PTR_LIBRARY_CHILD_CHILD) {
    return reinterpret_cast<cef_api_version_test_ref_ptr_library_child_t*>(
        CefApiVersionTestRefPtrLibraryChildChildCToCpp_Unwrap(
            reinterpret_cast<CefApiVersionTestRefPtrLibraryChildChild*>(c)));
  }
#endif
#if CEF_API_RANGE(13301, 13302)
  if (type == WT_API_VERSION_TEST_REF_PTR_LIBRARY_CHILD_CHILD_V1) {
    return reinterpret_cast<cef_api_version_test_ref_ptr_library_child_t*>(
        CefApiVersionTestRefPtrLibraryChildChildV1CToCpp_Unwrap(
            reinterpret_cast<CefApiVersionTestRefPtrLibraryChildChildV1*>(c)));
  }
#endif
#if CEF_API_ADDED(13302)
  if (type == WT_API_VERSION_TEST_REF_PTR_LIBRARY_CHILD_CHILD_V2) {
    return reinterpret_cast<cef_api_version_test_ref_ptr_library_child_t*>(
        CefApiVersionTestRefPtrLibraryChildChildV2CToCpp_Unwrap(
            reinterpret_cast<CefApiVersionTestRefPtrLibraryChildChildV2*>(c)));
  }
#endif
  CHECK(false) << __func__ << " called with unexpected class type " << type;
  return nullptr;
}

template <>
CefWrapperType CefCToCppRefCounted<
    CefApiVersionTestRefPtrLibraryChildCToCpp,
    CefApiVersionTestRefPtrLibraryChild,
    cef_api_version_test_ref_ptr_library_child_t>::kWrapperType =
    WT_API_VERSION_TEST_REF_PTR_LIBRARY_CHILD;
