#!/bin/bash

# This script can be used to patch libcef.so in Linux' versions of CEF, so
# that it won't attempt to create a "Downloads" directory whenever the user set
# the latter to their "home" directory or simply removed it. Beside being an
# invasive and dictatorial "feature", it is not even needed since we do not
# enable files downloading in Dullahan...

if [ -f libcef.so ] ; then
	# Seen in CEF 85+:
	perl -pi -e 's/\0Downloads\0/\0.local\0\0\0\0/' libcef.so
	# Seen in CEF 81:
	perl -pi -e 's/\x04Downloads\0/\x04.local\0\0\0\0/' libcef.so
	echo "Done."
else
	echo "libcef.so not found (must be in the current directory)"
fi
