#!/bin/bash

# turn on verbose debugging output
set -x
# make errors fatal
set -e

SQLITE_VERSION_NUM="3500300"
SQLITE_SITE="https://www.sqlite.org/2025/"
SQLITE_SOURCE_DIR="sqlite-amalgamation-$SQLITE_VERSION_NUM"
SQLITE_ARCHIVE="$SQLITE_SOURCE_DIR.zip"

if ! [ -d "$SQLITE_SOURCE_DIR" ] ; then
	if ! [ -f "$SQLITE_ARCHIVE" ] ; then
		wget "$SQLITE_SITE$SQLITE_ARCHIVE"
		if ! [ -f "$SQLITE_ARCHIVE" ] ; then
			exit 1
		fi
	fi
	unzip -q "$SQLITE_ARCHIVE"
fi
