rem Run this batch file from the Windows SDK Command Prompt

rem Before you can build sqlite-amalgamation for Windows, you must have
rem downloaded and extracted its sources.

rem Setup VS variables for a x86_64 build
call "\Program Files\Microsoft Visual Studio\2022\Community\VC\Auxiliary\Build\vcvars64.bat"

set sqlite_subdir=sqlite-amalgamation-3500300

set OPTIONS=/DSQLITE_DEFAULT_MEMSTATUS=0 /DSQLITE_MAX_EXPR_DEPTH=0 /DSQLITE_OMIT_DEPRECATED /DSQLITE_OMIT_SHARED_CACHE /DSQLITE_THREADSAFE=1 /DSQLITE_ENABLE_SESSION=1 /DSQLITE_ENABLE_COLUMN_METADATA=1 /DSQLITE_ENABLE_DBSTAT_VTAB=1 /DSQLITE_ENABLE_FTS3=1 /DSQLITE_ENABLE_FTS3_PARENTHESIS=1 /DSQLITE_ENABLE_GEOPOLY=1 /DSQLITE_ENABLE_JSON1=1 /DSQLITE_ENABLE_RTREE=1 /DSQLITE_ENABLE_STMTVTAB=1 /DSQLITE_ENABLE_RBU=1 /DSQLITE_ENABLE_MATH_FUNCTIONS=1

rem BEWARE: do not use a path containing spaces for this directory !
set top=%CD%

set packages_inc=%top%\packages\include
set packages_lib=%top%\packages\lib\release

set stage=%top%\stage
set stage_include=%stage%\include\
set stage_release=%stage%\lib\release\

del /s /q %stage%
md %stage%
md %stage_include%
md %stage_release%

set build_dir=%top%\%sqlite_subdir%
pushd %build_dir%
cl /c /EHsc %OPTIONS% sqlite3.c
lib sqlite3.obj

move /y sqlite3.lib %stage_release%
xcopy /q /s /i sqlite3.h %stage_include%\

popd
