#!/usr/bin/env bash

# Turn on verbose debugging output
set -x
# Make errors fatal
set -e

WEBRTC_SDK_ARCHIVE="webrtc-m137.7151.04.20-universal.17630578914-darwin64-17630578914.tar.zst"
WEBRTC_SDK_SITE="https://github.com/secondlife/3p-webrtc-build/releases/download/m137.7151.04.20-universal/"
ZTSD_ARCHIVE="zstd-darwin-1.5.5.tar.bz2"
ZTSD_SITE="http://sldev.free.fr/libraries/"

top=`pwd`
stage="$top/stage"
if [ -d "$stage" ] ; then
	rm -rf "$stage"
fi
mkdir -p "$stage" "$stage/include" "$stage/lib/release" "$stage/LICENSES"

if ! [ -d "include/webrtc" ] ; then
	curl -L -o "$WEBRTC_SDK_ARCHIVE" "$WEBRTC_SDK_SITE$WEBRTC_SDK_ARCHIVE"
	if [[ $WEBRTC_SDK_ARCHIVE == *".zst" ]] ; then
		if ! which zstd &>/dev/null ; then
			curl -L -o "$ZTSD_ARCHIVE" "$ZTSD_SITE$ZTSD_ARCHIVE"
			tar xf "$ZTSD_ARCHIVE"
			./bin/zstd -d "$WEBRTC_SDK_ARCHIVE"
			rm -rf ./bin
		else
			# In case 'tar' does not know about *.zst archives...
			zstd -d "$WEBRTC_SDK_ARCHIVE"
		fi
		WEBRTC_SDK_ARCHIVE=${WEBRTC_SDK_ARCHIVE%.zst}
		rm -f $WEBRTC_SDK_ARCHIVE.zst
	fi
	tar xf $WEBRTC_SDK_ARCHIVE
	rm -r "$WEBRTC_SDK_ARCHIVE"
	if [ -f autobuild-package.xml ] ; then
		rm -f autobuild-package.xml
	fi
	if [ -f LICENSES/webrtc-license.txt ] ; then
		mv -f LICENSES/webrtc-license.txt LICENSES/webrtc-sdk.txt
	fi
fi

if [ -d llwebrtc/build ] ; then
	rm -rf llwebrtc/build
fi
mkdir -p llwebrtc/build
pushd llwebrtc/build &>/dev/null
cmake -G "Xcode" -DCMAKE_OSX_DEPLOYMENT_TARGET="10.13" -DARCH:STRING="-m64 -fPIC" ..
xcodebuild -configuration Release -target llwebrtc -project llwebrtc.xcodeproj
popd &>/dev/null

mkdir -p "$stage/include"
mkdir -p "$stage/lib/release"
cp -a llwebrtc/build/Release/libllwebrtc.dylib "$stage/lib/release/"
cp -a llwebrtc/llwebrtc.h "$stage/include/"
cp -a LICENSES/webrtc* "$stage/LICENSES/"

pushd "$stage" &>/dev/null
DATE=`date +%Y%m%d`
tarball="llwebrtc-m137-darwin64-$DATE.tar.bz2"
tar cjf "../$tarball" *
popd &>/dev/null
md5 -r "$tarball"
