#!/usr/bin/env bash

# Turn on verbose debugging output
set -x
# Make errors fatal
set -e

WEBRTC_SDK_ARCHIVE="webrtc-m137.7151.04.20-universal.17630578914-windows64-17630578914.tar.zst"
WEBRTC_SDK_SITE="https://github.com/secondlife/3p-webrtc-build/releases/download/m137.7151.04.20-universal/"

top=`pwd`
stage="$top/stage"
if [ -d "$stage" ] ; then
	rm -rf "$stage"
fi
mkdir -p "$stage" "$stage/include" "$stage/lib/release" "$stage/LICENSES"

if ! [ -d "include/webrtc" ] ; then
	if ! [ -f "$WEBRTC_SDK_ARCHIVE" ] ; then
		wget "$WEBRTC_SDK_SITE$WEBRTC_SDK_ARCHIVE"
	fi
	tar xf $WEBRTC_SDK_ARCHIVE
	if [ -f autobuild-package.xml ] ; then
		rm -f autobuild-package.xml
	fi
	if [ -f LICENSES/webrtc-license.txt ] ; then
		mv -f LICENSES/webrtc-license.txt LICENSES/webrtc-sdk.txt
	fi
fi

cp -a LICENSES/webrtc* "$stage/LICENSES/"
cp -a llwebrtc/llwebrtc.h "$stage/include/"

echo "Use cmake-gui in $top/llwebrtc to create the VS2022 build solution."
