#!/bin/bash

# turn on verbose debugging output
set -x
# make errors fatal
set -e

MESHOPT_VERSION="0.24"
MESHOPT_SOURCE_URL="https://github.com/zeux/meshoptimizer/archive/refs/tags/v$MESHOPT_VERSION.tar.gz"
MESHOPT_SOURCE_DIR="meshoptimizer-$MESHOPT_VERSION"
MESHOPT_ARCHIVE="meshoptimizer-$MESHOPT_VERSION.tar.gz"

script=`readlink -f "$0" || echo "$0"`
top=`dirname "$script" || echo .`
stage="$top/stage"

cd $top
rm -rf build/ stage/
mkdir -p build "$stage/lib/release" "$stage/include" "$stage/LICENSES"

if ! [ -d "$MESHOPT_SOURCE_DIR" ] ; then
	if ! [ -f "$MESHOPT_ARCHIVE" ] ; then
		wget "$MESHOPT_SOURCE_URL" -O "$MESHOPT_ARCHIVE"
	fi
	tar xzf "$MESHOPT_ARCHIVE"
fi

pushd "$MESHOPT_SOURCE_DIR"
cp -a LICENSE.md "$stage/LICENSES/meshoptimizer.txt"
cp -a src/meshoptimizer.h "$stage/include/"
popd
